
(function monitoringAppLoader(win, doc) {
    const appId = '230ce197a434e101a80b213b72df64797737f873',
        sourceCodeVersion = '2025.7.10',
        customer = 'elsevier',
        apiHost = 'https://elsevierapi.proofcentral.com';

    function injectScriptTag() {
        return new Promise(function injectScriptTagReturn(resolve, reject) {
            let obj = win.smartlook = function smartlookFn() {
                    obj.api.push(arguments);
                },
                head = doc.getElementsByTagName('head')[0],
                scriptTag = doc.createElement('script');

            // eslint-disable-next-line no-array-constructor
            obj.api = new Array();
            scriptTag.async = true;
            scriptTag.type = 'text/javascript';
            scriptTag.charset = 'utf-8';
            scriptTag.src = 'https://rec.smartlook.com/recorder.js';
            scriptTag.onload = resolve;
            scriptTag.onerror = reject;
            head.appendChild(scriptTag);
        });
    }

    function getUrlParams(key) {
        var query, vars, pair, i;

        query = win.location.search.substring(1);
        vars = query.split('&');
        for (i = 0; i < vars.length; i += 1) {
            pair = vars[i].split('=');
            if (pair[0] === key) {
                return pair[1];
            }
        }

        return '';
    }

    function checkType(type) {
        var paramType = getUrlParams('type');

        return type === paramType;
    }

    function isMonitoringNeeded() {
        return checkType('cache') === false && checkType('preload') === false &&
            checkType('nocache') === false && checkType('automation') === false;
    }

    function checkCookieStatus() {
        let cookieEndPoint = apiHost + '/index.php/getSLCookieData/' + getUrlParams('token');

        return new Promise(function fetchPromiseFn(resolve, reject) {
            fetch(cookieEndPoint, {'method': 'GET', 'credentials': 'include'}).then(function fetchFn(response) {
                    if (response.ok === true &&
                        response.status >= 200 && response.status <= 299
                    ) {
                        return response.json();
                    }
                    return reject('cookie.policy.fetch.failed');
                }).then(function fetchResponse(cookieResponse) {
                    if (cookieResponse.success === true) {
                        return resolve(cookieResponse.data);
                    }
                    return reject(cookieResponse.message);
                }).catch(function errorFn(message) {
                    return reject(message);
                });
        });
    }

    function initMonitoring() {
        const token = getUrlParams('token');

        win.smartlook('init', appId);
        win.smartlook('identify', token, {
            'releaseVersion': sourceCodeVersion,
            'customer': customer
        });
    }

    if (isMonitoringNeeded() === true) {
        const appIdPlaceHolder = 'APPID';

        if (appId === `{{${appIdPlaceHolder}}}` || appId === '') {
            return;
        }
        checkCookieStatus().then(
            function cookieStatus(status) {
                if (status.isCookieAllowed === true) {
                    injectScriptTag().then(initMonitoring).catch(function errorFn() {
                        throw new Error('monitoring.script.load.fails');
                    });
                }
            }).catch(function errorFn(errorMessage) {
                throw new Error(errorMessage);
            })
    }
})(window, document);
